#CALCUL NUMERIQUE DE L'ALTITUDE (ET DE LA VITESSE) D'UN OBJET EN CHUTE LIBRE

import pylab
import matplotlib.pyplot as plt
from math import cos, sin, pi

#declaration des variables et de leur valeur initiale
g=9.81 #m.s-2
v=13 #m/s
alpha=40 #°
tau=0.025

x=0 #m
z0=2 #m
z=z0 #m ainsi z pourra etre traite comme une variable (au sens mathematique) et
#z0 reste constant, ce qui permet de l'utiliser pour le tracer de la courbe de reference
t=0 #s
vx=v*cos(alpha*pi/180)
vz=v*sin(alpha*pi/180)

#Pour la validation (tracer de la courbe de référence)
X=x
Z=z

#x et z (comme X et Z) sont des variables de type float, qu'il faut stocker dans
#des listes si on veut effectuer des tracers
xlist=[x]
zlist=[z]

Xlist=[X]
Zlist=[Z]

#Calcul pas à pas des valeurs prises par t, x, z, vz X et Z (vx est constante)...
while z>=0:
    x = x+vx*tau
    z = z+vz*tau
    t = t+tau
    vz = vz-g*tau

    X = v*cos(alpha*pi/180)*t
    Z = -0.5*g*t*t+v*sin(alpha*pi/180)*t+z0

#... et stockage des valeurs calculees dans les listes creees
    xlist=xlist+[x]
    zlist=zlist+[z]

    Xlist=Xlist+[X]
    Zlist=Zlist+[Z]

#Affichage des 2 courbes
plt.title('Trajectoire du projectile - tau='+str(tau)+' s')
plt.xlabel('distance parcourue (m)')
plt.ylabel('altitude (m)')
plt.plot(xlist, zlist, 'b.',label="calcul numerique")
plt.plot(Xlist, Zlist, 'r.', label="integration")
plt.legend()
plt.show()
